# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    is_random = "random" in opponent_program_code.lower()
    
    if always_d:
        return "D"
    if always_c:
        if len(my_history) % 3 == 1:
            return "D"
        else:
            return "C"
    if is_random:
        return opp_history[-1]
    
    if len(my_history) >= 2 and my_history[-1] == "D" and opp_history[-1] == "D" and my_history[-2] == "D" and opp_history[-2] == "D":
        return "C"
    
    if opp_history[-1] == "D":
        if len(my_history) >= 2 and my_history[-1] == "C" and my_history[-2] == "C":
            return "D"
        else:
            return "D" if random.random() < 0.9 else "C"
    else:
        return "C"